<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    public function type()
    {
        return $this->belongsTo('App\Models\ProjectTypes');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function participants()
    {
        return $this->hasMany('App\Models\ProjectParticipant');
    }

    public function tasks()
    {
        return $this->hasMany('App\Models\Task');
    }

}